/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Window
extends JFrame {
    private JTextField TextFieldHeight;
    private JTextField TextFieldCreatinine;
    private JTextField TextFieldAge;
    private JTextField TextFieldResult;
    private JLabel labelSex;
    private JLabel labelHeight;
    private JLabel labelCm;
    private JLabel labelCreatinine;
    private JLabel labelAge;
    private JLabel labelYear;
    private JLabel labelCHUV;
    private JLabel labelDummy;
    private JComboBox comboboxCreatinine;
    private JComboBox comboboxSex;
    private boolean valid = Boolean.FALSE;
    private JButton buttonCompute;
    private Window me = this;
    private JPanel panel;

    public Window() {
        this.setTitle("Quadratic Formula for Glomerular Filtration Rate in Children");
        this.setBounds(0, 0, 650, 300);
        this.setResizable(Boolean.FALSE);
        this.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        this.panel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(4, 8, 4, 8);
        this.labelSex = new JLabel("Sex:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.panel.add((Component)this.labelSex, gbc);
        this.comboboxSex = new JComboBox();
        this.comboboxSex.addItem("Male");
        this.comboboxSex.addItem("Female");
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.panel.add((Component)this.comboboxSex, gbc);
        this.labelHeight = new JLabel("Height:");
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.panel.add((Component)this.labelHeight, gbc);
        this.TextFieldHeight = new JTextField(6);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.panel.add((Component)this.TextFieldHeight, gbc);
        this.labelCm = new JLabel("[cm]");
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.panel.add((Component)this.labelCm, gbc);
        this.labelCreatinine = new JLabel("Creatinine:");
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.panel.add((Component)this.labelCreatinine, gbc);
        this.TextFieldCreatinine = new JTextField(6);
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.panel.add((Component)this.TextFieldCreatinine, gbc);
        this.comboboxCreatinine = new JComboBox();
        this.comboboxCreatinine.addItem("To select");
        this.comboboxCreatinine.addItem("mg/dl");
        this.comboboxCreatinine.addItem("\u00b5mol/l");
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.panel.add((Component)this.comboboxCreatinine, gbc);
        this.labelAge = new JLabel("Age:");
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.panel.add((Component)this.labelAge, gbc);
        this.TextFieldAge = new JTextField(6);
        gbc.gridx = 1;
        gbc.gridy = 4;
        this.panel.add((Component)this.TextFieldAge, gbc);
        this.labelYear = new JLabel("[year]");
        gbc.gridx = 2;
        gbc.gridy = 4;
        this.panel.add((Component)this.labelYear, gbc);
        this.buttonCompute = new JButton("Compute");
        EcouteurButtonCompute earb = new EcouteurButtonCompute();
        this.buttonCompute.addActionListener(earb);
        gbc.gridx = 0;
        gbc.gridy = 7;
        this.panel.add((Component)this.buttonCompute, gbc);
        this.TextFieldResult = new JTextField(20);
        gbc.gridx = 1;
        gbc.gridy = 7;
        this.panel.add((Component)this.TextFieldResult, gbc);
        this.labelDummy = new JLabel(" ");
        gbc.gridx = 1;
        gbc.gridy = 8;
        this.panel.add((Component)this.labelDummy, gbc);
        this.labelCHUV = new JLabel("Unit\u00e9 Universitaire Romande de N\u00e9phrologie P\u00e9diatrique-Site CHUV");
        gbc.gridx = 1;
        gbc.gridy = 9;
        this.panel.add((Component)this.labelCHUV, gbc);
        this.getContentPane().add(this.panel);
    }

    public double computeEstimation() {
        Double age;
        Double creatinine;
        Double height;
        this.valid = Boolean.TRUE;
        double result = 0.0;
        double k = 0.0;
        k = this.comboboxSex.getSelectedIndex() == 1 ? 25.68 : 21.53;
        String input = this.TextFieldHeight.getText();
        try {
            height = new Double(input);
            if (input.isEmpty() || height < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.TextFieldResult.setText("Please enter a valid height.");
            this.valid = Boolean.FALSE;
            return result;
        }
        input = this.TextFieldCreatinine.getText();
        try {
            creatinine = new Double(input);
            if (input.isEmpty() || creatinine < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.TextFieldResult.setText("Please enter a valid creatinine.");
            this.valid = Boolean.FALSE;
            return result;
        }
        input = this.TextFieldAge.getText();
        try {
            age = new Double(input);
            if (input.isEmpty() || age < 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.TextFieldResult.setText("Please enter a valid age.");
            this.valid = Boolean.FALSE;
            return result;
        }
        int index = this.comboboxCreatinine.getSelectedIndex();
        if (index == 0) {
            this.TextFieldResult.setText("Please select unit for creatinine.");
            this.valid = Boolean.FALSE;
            return result;
        }
        result = index == 1 ? 0.68 * (height / creatinine) - 8.0E-4 * (height / creatinine) * (height / creatinine) + 0.48 * age - k : 60.0 * (height / creatinine) - 6.25 * (height / creatinine) * (height / creatinine) + 0.48 * age - k;
        return result;
    }

    public class EcouteurButtonCompute
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            Double result = Window.this.computeEstimation();
            if (Window.this.valid) {
                Window.this.TextFieldResult.setText(result.toString());
            }
            Window.this.me.repaint();
        }
    }
}

